/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.expressionbuilder;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWFileURLDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.dialog.VWUsersDialog;
import filenet.vw.toolkit.utils.event.IVWExpressionToolbarActionListener;
import filenet.vw.toolkit.utils.event.VWExpressionToolbarActionEvent;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.IVWEditorTool;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionToolbar;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredUsersAndGroupsDialog;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;

class VWExpressionEditor
extends JPanel
implements IVWExpressionToolbarActionListener,
CaretListener {
    private VWExpressionToolbar m_toolbar = null;
    private JTextArea m_editorTextArea = null;
    private GridBagConstraints m_gbCons = null;
    private IVWEditorTool m_editorTool = null;
    private String m_expressionString = null;
    private int m_type = 1;
    private IVWPropertyData m_propertyData = null;
    private Container m_parent = null;

    public VWExpressionEditor(Container parent) {
        this.m_parent = parent;
    }

    public void init(IVWPropertyData propertyData, String expressionString, int type) {
        this.m_propertyData = propertyData;
        this.m_expressionString = expressionString;
        this.m_type = type;
        this.setLayout(new GridBagLayout());
        this.m_gbCons = new GridBagConstraints();
        this.initControls();
    }

    public void setEditorTool(IVWEditorTool editorTool) {
        this.m_editorTool = editorTool;
    }

    public String getSelectedText() {
        return this.m_editorTextArea.getSelectedText();
    }

    public void setDataType(int dataType) {
        this.m_type = dataType;
    }

    public String getExpression() {
        return this.m_editorTextArea.getText();
    }

    public void expressionToolbarActionPerformed(VWExpressionToolbarActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_toolbar) {
            int eventID = event.getID();
            switch (eventID) {
                case 1: {
                    this.performInsertAction();
                    break;
                }
                case 3: {
                    this.performClearAction();
                    break;
                }
                case 4: {
                    this.performAddOperatorAction(event.getData());
                    break;
                }
                case 5: {
                    this.performBrowseAction();
                }
            }
        }
    }

    public void caretUpdate(CaretEvent event) {
        if (event.getSource() == this.m_editorTextArea) {
            this.performCaretUpdate();
        }
    }

    protected VWParticipant[] stringToParticipantList(String participantString) {
        Object[] participants = null;
        if (participantString != null && participantString.length() > 2) {
            Vector<VWParticipant> participantsVector = new Vector<VWParticipant>();
            int len = participantString.length();
            block0: for (int i = 0; i < len; ++i) {
                char c = participantString.charAt(i);
                if (c == '{' || c == ',' || c != '\"') continue;
                String participant = "";
                for (int j = ++i; j < len; ++j) {
                    c = participantString.charAt(j);
                    if (c == '\"') {
                        VWParticipant vwparticipant = new VWParticipant(participant);
                        participantsVector.add(vwparticipant);
                        i = j;
                        continue block0;
                    }
                    participant = participant + participantString.charAt(j);
                }
            }
            participants = new VWParticipant[participantsVector.size()];
            participantsVector.copyInto(participants);
        }
        return participants;
    }

    protected String participantListToString(VWParticipant[] participants) {
        int count;
        String participantString = "{";
        if (participants != null && (count = participants.length) > 0) {
            for (int i = 0; i < count; ++i) {
                String participant = "\"" + participants[i].getParticipantName() + "\"";
                participantString = participantString + participant;
                if (i == count - 1) continue;
                participantString = participantString + ",";
            }
        }
        participantString = participantString + "}";
        return participantString;
    }

    private void initControls() {
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 1;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 1;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 1.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 2, 0, 2);
        this.m_editorTextArea = new JTextArea();
        this.m_editorTextArea.setText(this.m_expressionString);
        this.m_editorTextArea.addCaretListener(this);
        this.m_editorTextArea.requestDefaultFocus();
        this.m_editorTextArea.setLineWrap(true);
        this.add((Component)new JScrollPane(this.m_editorTextArea), this.m_gbCons);
        this.m_gbCons.anchor = 23;
        this.m_gbCons.fill = 2;
        this.m_gbCons.gridx = 0;
        this.m_gbCons.gridy = 0;
        this.m_gbCons.weightx = 1.0;
        this.m_gbCons.weighty = 0.0;
        this.m_gbCons.gridheight = 1;
        this.m_gbCons.gridwidth = 1;
        this.m_gbCons.insets = new Insets(0, 2, 0, 2);
        this.m_toolbar = new VWExpressionToolbar(3, this.m_type, this.m_propertyData.getShowParticipants());
        this.m_toolbar.addExpressionToolbarActionListener(this);
        this.add((Component)this.m_toolbar, this.m_gbCons);
    }

    private void performInsertAction() {
        try {
            if (this.m_editorTool != null) {
                String expressionItem = this.m_editorTool.getCurrentExpressionItem();
                String selectedText = this.m_editorTextArea.getSelectedText();
                if (selectedText == null) {
                    int caretPos = this.m_editorTextArea.getCaretPosition();
                    Document doc = this.m_editorTextArea.getDocument();
                    doc.insertString(caretPos, expressionItem, null);
                } else {
                    int startIndex = this.m_editorTextArea.getSelectionStart();
                    int endIndex = this.m_editorTextArea.getSelectionEnd();
                    this.m_editorTextArea.replaceRange(expressionItem, startIndex, endIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performClearAction() {
        this.m_editorTextArea.setText("");
    }

    private void performAddOperatorAction(Object eventData) {
        if (eventData != null) {
            String operatorString = eventData.toString();
            int caretPos = this.m_editorTextArea.getCaretPosition();
            this.m_editorTextArea.insert(operatorString, caretPos);
        }
    }

    private void performBrowseAction() {
        String resultString = null;
        switch (this.m_type) {
            case 32: {
                resultString = this.browseAttachments();
                break;
            }
            case 64: {
                resultString = this.browseParticipants();
            }
        }
        if (resultString != null) {
            int caretPos = this.m_editorTextArea.getCaretPosition();
            this.m_editorTextArea.insert(resultString, caretPos);
        }
    }

    private String browseAttachments() {
        String attachmentString = null;
        try {
            IVWIDMItem idmDoc = null;
            String[] resources = VWStringUtils.getResourcesFromString(VWResource.s_select_withHK);
            IVWIDMDialog assignAttachmentDialog = VWIDMBaseFactory.instance().getBrowseDialog(idmDoc, 95, resources[0], null);
            assignAttachmentDialog.setTitle(VWResource.s_browseForItem);
            assignAttachmentDialog.setButtonMnemonic(resources[1]);
            assignAttachmentDialog.setButtonTooltip(VWResource.s_select);
            switch (assignAttachmentDialog.showDialog(this.m_parent)) {
                case 0: {
                    IVWIDMItem idmItem = assignAttachmentDialog.getSelectedItem();
                    if (idmItem == null) break;
                    VWAttachment newAttachment = idmItem.getVWAttachment();
                    attachmentString = newAttachment.toString();
                    break;
                }
                case 2: {
                    VWFileURLDialog URLDlg = null;
                    URLDlg = this.m_parent instanceof Dialog ? new VWFileURLDialog((Dialog)this.m_parent) : new VWFileURLDialog((Frame)this.m_parent);
                    int nURLReturnVal = URLDlg.showDialog(this.m_parent);
                    if (nURLReturnVal != 0) break;
                    String fileName = URLDlg.getSelectedFile();
                    if (fileName != null) {
                        VWAttachment newAttachment = new VWAttachment();
                        newAttachment.setType(5);
                        newAttachment.setId(fileName);
                        attachmentString = newAttachment.toString();
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (attachmentString != null) {
            attachmentString = "\"" + attachmentString + "\"";
        }
        return attachmentString;
    }

    private String browseParticipants() {
        String participantString = null;
        try {
            if (this.m_propertyData != null) {
                VWModalDialog usersDialog = null;
                VWSession vwSession = this.m_propertyData.getVWSession();
                if (this.m_parent instanceof Frame) {
                    usersDialog = vwSession.getSecurityDatabaseType() == 1 ? new VWFilteredUsersAndGroupsDialog((Frame)this.m_parent, vwSession) : new VWUsersDialog((Frame)this.m_parent, vwSession);
                } else if (this.m_parent instanceof Dialog) {
                    usersDialog = this.m_propertyData.getVWSession().getSecurityDatabaseType() == 1 ? new VWFilteredUsersAndGroupsDialog((Dialog)this.m_parent, vwSession) : new VWUsersDialog((Dialog)this.m_parent, vwSession);
                } else {
                    throw new Exception();
                }
                VWParticipant[] oldParticipants = this.stringToParticipantList(participantString);
                VWParticipantItem[] participantItems = VWDefaultSessionProxy.getFullParticipantItems(oldParticipants, true);
                usersDialog.init(participantItems, null);
                usersDialog.setVisible(true);
                if (usersDialog.getStatus() == 1) {
                    VWParticipantItem[] participants = usersDialog.getParticipants();
                    if (participants == null) {
                        participants = new VWParticipantItem[]{};
                    }
                    VWParticipant[] newParticipants = VWDefaultSessionProxy.getParticipantsFromParticipantItems(participants, false);
                    participantString = this.participantListToString(newParticipants);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return participantString;
    }

    private void performCaretUpdate() {
        String selectedText = this.m_editorTextArea.getSelectedText();
        boolean isEnable = selectedText != null;
        this.m_editorTool.setEnableControls(isEnable);
    }
}

